﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net.Sockets;

namespace Remoting
{
	/// <summary>
	/// wraps the tcp client.
	/// </summary>
	public class RClientSocket : RSocket
	{
		private TcpClient client;

		public RClientSocket(string host, int port)
		{
			client = new TcpClient(host, port);
		}

		public override NetworkStream GetStream()
		{
			return client.GetStream();
		}

		#region IDisposable Members

		public override void Dispose()
		{
			client.Close();
		}

		#endregion

		public override string ToString()
		{
			return client.Client.LocalEndPoint.ToString();
		}
	}
}
